#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Data.SqlClient;

#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_Utility : BaseTest 
	{
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void IsDefaultPrinterConfigured_Pass()
		{
			//No way to make sure via code a default printer is setup for this test to be worthwhile
			bool tmpValue = Utility.IsDefaultPrinterConfigured;

			Assert.AreEqual(tmpValue, Utility.IsDefaultPrinterConfigured);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void IsDefaultPrinterConfigured_Fail()
		{
			//No way to turn off a default printer in code to test the failure condition
		}

		[Test]
		public void CompileDate_Pass()
		{
			string tmpDate = Utility.CompileDate;
			Assert.AreEqual(tmpDate, Utility.CompileDate);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void CompileDate_Fail()
		{
			//Nothing to fail
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void DumpTransactionalInputs_Pass()
		{
			//Debug code for developers - tests not required
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void DumpTransactionalInputs_Fail()
		{
			//Debug code for developers - tests not required
		}


		[Test]
		public void GetColumnType_Pass()
		{
			Assert.AreEqual(SqlDbType.Bit, Utility.GetColumnType(typeof(bool)) );
			Assert.AreEqual(SqlDbType.Binary, Utility.GetColumnType(typeof(byte[])));
			Assert.AreEqual(SqlDbType.TinyInt, Utility.GetColumnType(typeof(byte)));
			Assert.AreEqual(SqlDbType.UniqueIdentifier, Utility.GetColumnType(typeof(System.Guid)));
			Assert.AreEqual(SqlDbType.VarChar, Utility.GetColumnType(typeof(string)));
			Assert.AreEqual(SqlDbType.Int, Utility.GetColumnType(typeof(System.Int32)));
			Assert.AreEqual(SqlDbType.Decimal, Utility.GetColumnType(typeof(decimal)));
			Assert.AreEqual(SqlDbType.DateTime, Utility.GetColumnType(typeof(System.DateTime)));
			Assert.AreEqual(SqlDbType.Char, Utility.GetColumnType(typeof(char)));

			//Test the default condition
			Assert.AreEqual( SqlDbType.VarChar, Utility.GetColumnType(typeof(System.Single)));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetColumnType_Fail()
		{
		}

		[Test]
		public void GetDonationTypeIdFromChar_Pass()
		{
			Assert.AreEqual(1, Utility.GetDonationTypeIdFromChar('0'));
			Assert.AreEqual(2, Utility.GetDonationTypeIdFromChar('V'));
			Assert.AreEqual(3, Utility.GetDonationTypeIdFromChar('R'));
			Assert.AreEqual(4, Utility.GetDonationTypeIdFromChar('S'));
			Assert.AreEqual(5, Utility.GetDonationTypeIdFromChar('T'));
			Assert.AreEqual(6, Utility.GetDonationTypeIdFromChar('P'));
			Assert.AreEqual(7, Utility.GetDonationTypeIdFromChar('r'));
			Assert.AreEqual(8, Utility.GetDonationTypeIdFromChar('s'));
			Assert.AreEqual(9, Utility.GetDonationTypeIdFromChar('A'));
			Assert.AreEqual(10, Utility.GetDonationTypeIdFromChar('1'));
			Assert.AreEqual(11, Utility.GetDonationTypeIdFromChar('X'));
			Assert.AreEqual(12, Utility.GetDonationTypeIdFromChar('D'));
			Assert.AreEqual(13, Utility.GetDonationTypeIdFromChar('d'));
			Assert.AreEqual(14, Utility.GetDonationTypeIdFromChar('2'));
			Assert.AreEqual(15, Utility.GetDonationTypeIdFromChar('L'));
			Assert.AreEqual(16, Utility.GetDonationTypeIdFromChar('E'));
			Assert.AreEqual(17, Utility.GetDonationTypeIdFromChar('Q'));
			Assert.AreEqual(18, Utility.GetDonationTypeIdFromChar('3'));
			Assert.AreEqual(19, Utility.GetDonationTypeIdFromChar('4'));
			Assert.AreEqual(20, Utility.GetDonationTypeIdFromChar('5'));
		}

		[Test]
		public void GetDonationTypeIdFromChar_Fail()
		{
			Assert.AreEqual(char.MinValue, Utility.GetDonationTypeIdFromChar('@'));
		}

		[Test]
		public void GetBarcodeTypeCodeCharFromEnum_Pass()
		{
			Assert.AreEqual('C', Utility.GetBarcodeTypeCodeCharFromEnum(BarcodeType.Codabar));
			Assert.AreEqual('I', Utility.GetBarcodeTypeCodeCharFromEnum(BarcodeType.ISBT128));
			Assert.AreEqual(char.MinValue, Utility.GetBarcodeTypeCodeCharFromEnum(BarcodeType.None));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBarcodeTypeCodeCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetBarcodeTypeFromString_Pass()
		{
			Assert.AreEqual(BarcodeType.Codabar, Utility.GetBarcodeTypeFromString("C"));
			Assert.AreEqual(BarcodeType.ISBT128, Utility.GetBarcodeTypeFromString("I"));
			Assert.AreEqual(BarcodeType.None, Utility.GetBarcodeTypeFromString("X"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBarcodeTypeFromString_Fail()
		{
		}

		[Test]
		public void GetLocationTypeFromString_Pass()
		{
			Assert.AreEqual(LocationType.Inpatient, Utility.GetLocationTypeFromString("I"));
			Assert.AreEqual(LocationType.Outpatient, Utility.GetLocationTypeFromString("O"));
			Assert.AreEqual(LocationType.Other, Utility.GetLocationTypeFromString("X"));
			Assert.AreEqual(LocationType.Unknown, Utility.GetLocationTypeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLocationTypeFromString_Fail()
		{
		}

		[Test]
		public void GetRecordStatusCodeCharFromEnum_Pass()
		{
			Assert.AreEqual('A', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.Active));
			Assert.AreEqual('C', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.Converted));
			Assert.AreEqual('E', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.ErrorCorrected));
			Assert.AreEqual('H', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.Historical));
			Assert.AreEqual('I', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.Incomplete));
			Assert.AreEqual('L', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.LocalEntry));
			Assert.AreEqual('N', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.NationalStandard));
			Assert.AreEqual('X', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.Inactive));
			Assert.AreEqual('U', Utility.GetRecordStatusCodeCharFromEnum(RecordStatusCode.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecordStatusCodeCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetDonationTypeCodeCharFromEnum_Pass()
		{
			Assert.AreEqual('V', Utility.GetDonationTypeCodeCharFromEnum(DonationType.VolunteerAllogeneicDonor));
			Assert.AreEqual('R', Utility.GetDonationTypeCodeCharFromEnum(DonationType.VolunteerResearchDonor));
			Assert.AreEqual('S', Utility.GetDonationTypeCodeCharFromEnum(DonationType.VolunteerSourceDonor));
			Assert.AreEqual('T', Utility.GetDonationTypeCodeCharFromEnum(DonationType.VolunteerTherapeuticCollection));
			Assert.AreEqual('P', Utility.GetDonationTypeCodeCharFromEnum(DonationType.PaidAllogeneicCollection));
			Assert.AreEqual('r', Utility.GetDonationTypeCodeCharFromEnum(DonationType.PaidResearchCollection));
			Assert.AreEqual('s', Utility.GetDonationTypeCodeCharFromEnum(DonationType.PaidSourceCollection));
			Assert.AreEqual('A', Utility.GetDonationTypeCodeCharFromEnum(DonationType.AutologousEligibleForCrossover));
			Assert.AreEqual('1', Utility.GetDonationTypeCodeCharFromEnum(DonationType.ForAutologousUseOnly));
			Assert.AreEqual('X', Utility.GetDonationTypeCodeCharFromEnum(DonationType.ForAutologousUseOnlyBiohazardous));
			Assert.AreEqual('D', Utility.GetDonationTypeCodeCharFromEnum(DonationType.VolunteerDirectedEligibeForCrossover));
			Assert.AreEqual('d', Utility.GetDonationTypeCodeCharFromEnum(DonationType.PaidDirectedEligibleForCrossover));
			Assert.AreEqual('2', Utility.GetDonationTypeCodeCharFromEnum(DonationType.ForDirectedDonorUseOnly));
			Assert.AreEqual('L', Utility.GetDonationTypeCodeCharFromEnum(DonationType.ForDirectedDonorUseOnlyLimitedExposure));
			Assert.AreEqual('E', Utility.GetDonationTypeCodeCharFromEnum(DonationType.ForDirectedDonorUseOnlyMedicalException));
			Assert.AreEqual('Q', Utility.GetDonationTypeCodeCharFromEnum(DonationType.SeeSpecialTestingBarcode));
			Assert.AreEqual('3', Utility.GetDonationTypeCodeCharFromEnum(DonationType.ForDirectedDonorUseOnlyBiohazardous));
			Assert.AreEqual('4', Utility.GetDonationTypeCodeCharFromEnum(DonationType.DesignatedDonor));
			Assert.AreEqual('5', Utility.GetDonationTypeCodeCharFromEnum(DonationType.DedicatedDonor));
			Assert.AreEqual('U', Utility.GetDonationTypeCodeCharFromEnum(DonationType.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDonationTypeCodeCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetDonationTypeCodeEnumFromChar_Pass()
		{
			Assert.AreEqual(DonationType.VolunteerAllogeneicDonor, Utility.GetDonationTypeCodeEnumFromChar('V'));
			Assert.AreEqual(DonationType.VolunteerResearchDonor, Utility.GetDonationTypeCodeEnumFromChar('R'));
			Assert.AreEqual(DonationType.VolunteerSourceDonor, Utility.GetDonationTypeCodeEnumFromChar('S'));
			Assert.AreEqual(DonationType.VolunteerTherapeuticCollection, Utility.GetDonationTypeCodeEnumFromChar('T'));
			Assert.AreEqual(DonationType.PaidAllogeneicCollection, Utility.GetDonationTypeCodeEnumFromChar('P'));
			Assert.AreEqual(DonationType.PaidResearchCollection, Utility.GetDonationTypeCodeEnumFromChar('r'));
			Assert.AreEqual(DonationType.PaidSourceCollection, Utility.GetDonationTypeCodeEnumFromChar('s'));
			Assert.AreEqual(DonationType.AutologousEligibleForCrossover, Utility.GetDonationTypeCodeEnumFromChar('A'));
			Assert.AreEqual(DonationType.ForAutologousUseOnly, Utility.GetDonationTypeCodeEnumFromChar('1'));
			Assert.AreEqual(DonationType.ForAutologousUseOnlyBiohazardous, Utility.GetDonationTypeCodeEnumFromChar('X'));
			Assert.AreEqual(DonationType.VolunteerDirectedEligibeForCrossover, Utility.GetDonationTypeCodeEnumFromChar('D'));
			Assert.AreEqual(DonationType.PaidDirectedEligibleForCrossover, Utility.GetDonationTypeCodeEnumFromChar('d'));
			Assert.AreEqual(DonationType.ForDirectedDonorUseOnly, Utility.GetDonationTypeCodeEnumFromChar('2'));
			Assert.AreEqual(DonationType.ForDirectedDonorUseOnlyLimitedExposure, Utility.GetDonationTypeCodeEnumFromChar('L'));
			Assert.AreEqual(DonationType.ForDirectedDonorUseOnlyMedicalException, Utility.GetDonationTypeCodeEnumFromChar('E'));
			Assert.AreEqual(DonationType.SeeSpecialTestingBarcode, Utility.GetDonationTypeCodeEnumFromChar('Q'));
			Assert.AreEqual(DonationType.ForDirectedDonorUseOnlyBiohazardous, Utility.GetDonationTypeCodeEnumFromChar('3'));
			Assert.AreEqual(DonationType.DesignatedDonor, Utility.GetDonationTypeCodeEnumFromChar('4'));
			Assert.AreEqual(DonationType.DedicatedDonor, Utility.GetDonationTypeCodeEnumFromChar('5'));
			Assert.AreEqual(DonationType.Unknown, Utility.GetDonationTypeCodeEnumFromChar('U'));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDonationTypeCodeEnumFromChar_Fail()
		{
		}

		[Test]
		public void GetRecordStatusCodeFromString_Pass()
		{
			Assert.AreEqual(RecordStatusCode.Active, Utility.GetRecordStatusCodeFromString("A"));
			Assert.AreEqual(RecordStatusCode.Converted, Utility.GetRecordStatusCodeFromString("C"));
			Assert.AreEqual(RecordStatusCode.ErrorCorrected, Utility.GetRecordStatusCodeFromString("E"));
			Assert.AreEqual(RecordStatusCode.Historical, Utility.GetRecordStatusCodeFromString("H"));
			Assert.AreEqual(RecordStatusCode.Incomplete, Utility.GetRecordStatusCodeFromString("I"));
			Assert.AreEqual(RecordStatusCode.LocalEntry, Utility.GetRecordStatusCodeFromString("L"));
			Assert.AreEqual(RecordStatusCode.NationalStandard, Utility.GetRecordStatusCodeFromString("N"));
			Assert.AreEqual(RecordStatusCode.Inactive, Utility.GetRecordStatusCodeFromString("X"));
			Assert.AreEqual(RecordStatusCode.Unknown, Utility.GetRecordStatusCodeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecordStatusCodeFromString_Fail()
		{
		}

		[Test]
		public void GetUnitStatusTextFromEnum_Pass()
		{
			Assert.AreEqual("Available", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Available));
			Assert.AreEqual("Crossmatched", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.CrossmatchedAssigned));
			Assert.AreEqual("Discarded", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Discarded));
			Assert.AreEqual("Issued", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Issued));
			Assert.AreEqual("Limited", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Limited));
			Assert.AreEqual("Modified", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Modified));
			Assert.AreEqual("Transferred", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Transferred));
			Assert.AreEqual("Transfused", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Transfused));
			Assert.AreEqual("Assigned", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Assigned));
			Assert.AreEqual("Unknown", Utility.GetUnitStatusTextFromEnum(UnitStatusCode.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUnitStatusTextFromEnum_Fail()
		{
		}

		[Test]
		public void GetUnitStatusCodeCharFromEnum_Pass()
		{
			Assert.AreEqual('A', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Available));
			Assert.AreEqual('C', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.CrossmatchedAssigned));
			Assert.AreEqual('D', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Discarded));
			Assert.AreEqual('I', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Issued));
			Assert.AreEqual('L', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Limited));
			Assert.AreEqual('M', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Modified));
			Assert.AreEqual('X', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Transferred));
			Assert.AreEqual('T', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Transfused));
			Assert.AreEqual('S', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Assigned));
			Assert.AreEqual('U', Utility.GetUnitStatusCodeCharFromEnum(UnitStatusCode.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUnitStatusCodeCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetUnitStatusCodeFromString_Pass()
		{
			Assert.AreEqual(UnitStatusCode.Available, Utility.GetUnitStatusCodeFromString("A"));
			Assert.AreEqual(UnitStatusCode.CrossmatchedAssigned, Utility.GetUnitStatusCodeFromString("C"));
			Assert.AreEqual(UnitStatusCode.Discarded, Utility.GetUnitStatusCodeFromString("D"));
			Assert.AreEqual(UnitStatusCode.Issued, Utility.GetUnitStatusCodeFromString("I"));
			Assert.AreEqual(UnitStatusCode.Limited, Utility.GetUnitStatusCodeFromString("L"));
			Assert.AreEqual(UnitStatusCode.Modified, Utility.GetUnitStatusCodeFromString("M"));
			Assert.AreEqual(UnitStatusCode.Transferred, Utility.GetUnitStatusCodeFromString("X"));
			Assert.AreEqual(UnitStatusCode.Transfused, Utility.GetUnitStatusCodeFromString("T"));
			Assert.AreEqual(UnitStatusCode.Assigned, Utility.GetUnitStatusCodeFromString("S"));
			Assert.AreEqual(UnitStatusCode.Unknown, Utility.GetUnitStatusCodeFromString("U"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUnitStatusCodeFromString_Fail()
		{
		}

		[Test]
		public void GetQuarantineEnum_Pass()
		{
			Assert.AreEqual(QuarantineComment.IncompleteDonorScreeningTest, Utility.GetQuarantineEnum("I"));
			Assert.AreEqual(QuarantineComment.PositiveDonorScreeningTest, Utility.GetQuarantineEnum("P"));
			Assert.AreEqual(QuarantineComment.StorageOutsideMonitoredArea, Utility.GetQuarantineEnum("S"));
			Assert.AreEqual(QuarantineComment.VisualInspectionUnsatisfactory, Utility.GetQuarantineEnum("V"));
			Assert.AreEqual(QuarantineComment.ABOInconclusive, Utility.GetQuarantineEnum("A"));
			Assert.AreEqual(QuarantineComment.Other, Utility.GetQuarantineEnum("O"));
			Assert.AreEqual(QuarantineComment.Unknown, Utility.GetQuarantineEnum("U"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetQuarantineEnum_Fail()
		{
		}

		[Test]
		public void GetQuarantineCharFromEnum_Pass()
		{
			Assert.AreEqual('I', Utility.GetQuarantineCharFromEnum(QuarantineComment.IncompleteDonorScreeningTest));
			Assert.AreEqual('P', Utility.GetQuarantineCharFromEnum(QuarantineComment.PositiveDonorScreeningTest));
			Assert.AreEqual('S', Utility.GetQuarantineCharFromEnum(QuarantineComment.StorageOutsideMonitoredArea));
			Assert.AreEqual('V', Utility.GetQuarantineCharFromEnum(QuarantineComment.VisualInspectionUnsatisfactory));
			Assert.AreEqual('A', Utility.GetQuarantineCharFromEnum(QuarantineComment.ABOInconclusive));
			Assert.AreEqual('O', Utility.GetQuarantineCharFromEnum(QuarantineComment.Other));
			Assert.AreEqual('U', Utility.GetQuarantineCharFromEnum(QuarantineComment.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetQuarantineCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetDiscardEnum_Pass()
		{

			Assert.AreEqual(DiscardComment.DispositionForResearch, Utility.GetDiscardEnum("D"));
			Assert.AreEqual(DiscardComment.Incinerated, Utility.GetDiscardEnum("I"));
			Assert.AreEqual(DiscardComment.Punctured, Utility.GetDiscardEnum("P"));
			Assert.AreEqual(DiscardComment.RupturedDuringThaw, Utility.GetDiscardEnum("R"));
			Assert.AreEqual(DiscardComment.Other, Utility.GetDiscardEnum("O"));
			Assert.AreEqual(DiscardComment.Unknown, Utility.GetDiscardEnum("U"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDiscardEnum_Fail()
		{
		}

		[Test]
		public void GetDiscardCharFromEnum_Pass()
		{
			Assert.AreEqual('D', Utility.GetDiscardCharFromEnum(DiscardComment.DispositionForResearch));
			Assert.AreEqual('I', Utility.GetDiscardCharFromEnum(DiscardComment.Incinerated));
			Assert.AreEqual('P', Utility.GetDiscardCharFromEnum(DiscardComment.Punctured));
			Assert.AreEqual('R', Utility.GetDiscardCharFromEnum(DiscardComment.RupturedDuringThaw));
			Assert.AreEqual('O', Utility.GetDiscardCharFromEnum(DiscardComment.Other));
			Assert.AreEqual('U', Utility.GetDiscardCharFromEnum(DiscardComment.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDiscardCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetReportTypeFromInt_Pass()
		{
			Assert.AreEqual(ReportType.AuditTrail, Utility.GetReportTypeFromInt(1));
			Assert.AreEqual(ReportType.CostAccounting, Utility.GetReportTypeFromInt(2));
			Assert.AreEqual(ReportType.DivisionInventory, Utility.GetReportTypeFromInt(3));
			Assert.AreEqual(ReportType.DownTime, Utility.GetReportTypeFromInt(4));
			Assert.AreEqual(ReportType.DivisionWorkload, Utility.GetReportTypeFromInt(5));
			Assert.AreEqual(ReportType.Exception, Utility.GetReportTypeFromInt(6));
			Assert.AreEqual(ReportType.TransfusionComplication, Utility.GetReportTypeFromInt(7));
			Assert.AreEqual(ReportType.TransfusionEffectiveness, Utility.GetReportTypeFromInt(8));
			Assert.AreEqual(ReportType.InappropriateTransfusionRequest, Utility.GetReportTypeFromInt(9));
			Assert.AreEqual(ReportType.Unknown, Utility.GetReportTypeFromInt(10));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportTypeFromInt_Fail()
		{
		}

		[Test]
		public void GetProductModificationCharFromEnum_Pass()
		{
			Assert.AreEqual('T', Utility.GetProductModificationCharFromEnum(ProductModification.Thawed));
			Assert.AreEqual('P', Utility.GetProductModificationCharFromEnum(ProductModification.Pooled));
			Assert.AreEqual('U', Utility.GetProductModificationCharFromEnum(ProductModification.PoolThawCryo));
			Assert.AreEqual('S', Utility.GetProductModificationCharFromEnum(ProductModification.SplitAdult));
			Assert.AreEqual('I', Utility.GetProductModificationCharFromEnum(ProductModification.Irradiated));
			Assert.AreEqual('L', Utility.GetProductModificationCharFromEnum(ProductModification.LeukoReduced));
			Assert.AreEqual('V', Utility.GetProductModificationCharFromEnum(ProductModification.VolumeReduced));
			Assert.AreEqual('W', Utility.GetProductModificationCharFromEnum(ProductModification.Washed));
			Assert.AreEqual('R', Utility.GetProductModificationCharFromEnum(ProductModification.Rejuvenated));
			Assert.AreEqual('F', Utility.GetProductModificationCharFromEnum(ProductModification.Frozen));
			Assert.AreEqual('D', Utility.GetProductModificationCharFromEnum(ProductModification.Deglycerolized));
			Assert.AreEqual(' ', Utility.GetProductModificationCharFromEnum(ProductModification.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductModificationCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetWorkloadEventStatusCodeCharFromEnum_Pass()
		{
			Assert.AreEqual('E', Utility.GetWorkloadEventStatusCodeCharFromEnum(WorkloadEventStatus.Error));
			Assert.AreEqual('I', Utility.GetWorkloadEventStatusCodeCharFromEnum(WorkloadEventStatus.InProcess));
			Assert.AreEqual('P', Utility.GetWorkloadEventStatusCodeCharFromEnum(WorkloadEventStatus.PendingProcessing));
			Assert.AreEqual('S', Utility.GetWorkloadEventStatusCodeCharFromEnum(WorkloadEventStatus.SucessfullyProcessed));
			Assert.AreEqual('U', Utility.GetWorkloadEventStatusCodeCharFromEnum(WorkloadEventStatus.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetWorkloadEventStatusCodeCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetWorkloadEventStatusCodeEnumFromChar_Pass()
		{
			Assert.AreEqual(WorkloadEventStatus.Error, Utility.GetWorkloadEventStatusCodeEnumFromChar('E'));
			Assert.AreEqual(WorkloadEventStatus.InProcess, Utility.GetWorkloadEventStatusCodeEnumFromChar('I'));
			Assert.AreEqual(WorkloadEventStatus.PendingProcessing, Utility.GetWorkloadEventStatusCodeEnumFromChar('P'));
			Assert.AreEqual(WorkloadEventStatus.SucessfullyProcessed, Utility.GetWorkloadEventStatusCodeEnumFromChar('S'));
			Assert.AreEqual(WorkloadEventStatus.Unknown, Utility.GetWorkloadEventStatusCodeEnumFromChar('U'));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetWorkloadEventStatusCodeEnumFromChar_Fail()
		{
		}

		[Test]
		public void GetProductModificationCodeFromString_Pass()
		{
			Assert.AreEqual(ProductModification.Thawed, Utility.GetProductModificationCodeFromString("T"));
			Assert.AreEqual(ProductModification.Pooled, Utility.GetProductModificationCodeFromString("P"));
			Assert.AreEqual(ProductModification.PoolThawCryo, Utility.GetProductModificationCodeFromString("U"));
			Assert.AreEqual(ProductModification.SplitAdult, Utility.GetProductModificationCodeFromString("S"));
			Assert.AreEqual(ProductModification.Irradiated, Utility.GetProductModificationCodeFromString("I"));
			Assert.AreEqual(ProductModification.LeukoReduced, Utility.GetProductModificationCodeFromString("L"));
			Assert.AreEqual(ProductModification.VolumeReduced, Utility.GetProductModificationCodeFromString("V"));
			Assert.AreEqual(ProductModification.Washed, Utility.GetProductModificationCodeFromString("W"));
			Assert.AreEqual(ProductModification.Rejuvenated, Utility.GetProductModificationCodeFromString("R"));
			Assert.AreEqual(ProductModification.Frozen, Utility.GetProductModificationCodeFromString("F"));
			Assert.AreEqual(ProductModification.Deglycerolized, Utility.GetProductModificationCodeFromString("D"));
			Assert.AreEqual(ProductModification.Unknown, Utility.GetProductModificationCodeFromString(" "));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductModificationCodeFromString_Fail()
		{
		}

		[Test]
		public void GetProductModificationTextFromEnum_Pass()
		{
			Assert.AreEqual("thaw", Utility.GetProductModificationTextFromEnum(ProductModification.Thawed));
			Assert.AreEqual("pool", Utility.GetProductModificationTextFromEnum(ProductModification.Pooled));
			Assert.AreEqual("pool/thaw", Utility.GetProductModificationTextFromEnum(ProductModification.PoolThawCryo));
			Assert.AreEqual("split", Utility.GetProductModificationTextFromEnum(ProductModification.SplitAdult));
			Assert.AreEqual("irradiate", Utility.GetProductModificationTextFromEnum(ProductModification.Irradiated));
			Assert.AreEqual("leuko reduce", Utility.GetProductModificationTextFromEnum(ProductModification.LeukoReduced));
			Assert.AreEqual("volume reduce", Utility.GetProductModificationTextFromEnum(ProductModification.VolumeReduced));
			Assert.AreEqual("wash", Utility.GetProductModificationTextFromEnum(ProductModification.Washed));
			Assert.AreEqual("rejuvenate", Utility.GetProductModificationTextFromEnum(ProductModification.Rejuvenated));
			Assert.AreEqual("freeze", Utility.GetProductModificationTextFromEnum(ProductModification.Frozen));
			Assert.AreEqual("deglycerolize", Utility.GetProductModificationTextFromEnum(ProductModification.Deglycerolized));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductModificationTextFromEnum_Fail()
		{
		}

		[Test]
		public void GetSpecimenTypeFromString_Pass()
		{
			Assert.AreEqual(SpecimenType.Blood, Utility.GetSpecimenTypeFromString("BLOOD"));
			Assert.AreEqual(SpecimenType.Plasma, Utility.GetSpecimenTypeFromString("PLASMA"));
			Assert.AreEqual(SpecimenType.Serum, Utility.GetSpecimenTypeFromString("SERUM"));
			Assert.AreEqual(SpecimenType.Unknown, Utility.GetSpecimenTypeFromString("DONUTS"));
			Assert.AreEqual(SpecimenType.Blood, Utility.GetSpecimenTypeFromString("BLOOD"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSpecimenTypeFromString_Fail()
		{
		}

		[Test]
		public void GetModificationMethodCharFromEnum_Pass()
		{
			Assert.AreEqual('C', Utility.GetModificationMethodCharFromEnum(ModifyUnitMethod.Closed));
			Assert.AreEqual('S', Utility.GetModificationMethodCharFromEnum(ModifyUnitMethod.SterileConnectingDevice));
			Assert.AreEqual('O', Utility.GetModificationMethodCharFromEnum(ModifyUnitMethod.Open));
			Assert.AreEqual(char.MinValue, Utility.GetModificationMethodCharFromEnum(ModifyUnitMethod.None));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetModificationMethodCharFromEnum_Fail()
		{
		}

		[Test]
		public void GetModificationMethodEnumFromString_Pass()
		{
			Assert.AreEqual(ModifyUnitMethod.Closed, Utility.GetModificationMethodEnumFromString("C"));
			Assert.AreEqual(ModifyUnitMethod.SterileConnectingDevice, Utility.GetModificationMethodEnumFromString("S"));
			Assert.AreEqual(ModifyUnitMethod.Open, Utility.GetModificationMethodEnumFromString("O"));
			Assert.AreEqual(ModifyUnitMethod.None, Utility.GetModificationMethodEnumFromString(""));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetModificationMethodEnumFromString_Fail()
		{
		}

		[Test]
		public void GetShipmentDirectionFromEnum_Pass()
		{
			Assert.AreEqual(true, Utility.GetShipmentDirectionFromEnum(ShipmentDirection.IncomingShipment));
			Assert.AreEqual(false, Utility.GetShipmentDirectionFromEnum(ShipmentDirection.OutgoingShipment));
			Assert.AreEqual(false, Utility.GetShipmentDirectionFromEnum(ShipmentDirection.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetShipmentDirectionFromEnum_Fail()
		{
		}

		[Test]
		public void GetShipmentDirectionFromBool_Pass()
		{
			Assert.AreEqual(ShipmentDirection.IncomingShipment, Utility.GetShipmentDirectionFromBool(true));
			Assert.AreEqual(ShipmentDirection.OutgoingShipment, Utility.GetShipmentDirectionFromBool(false));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetShipmentDirectionFromBool_Fail()
		{
		}

		[Test]
		public void GetTransfusionCategoryCodeFromString_Pass()
		{
			Assert.AreEqual(TransfusionRequirementCategoryCode.ComponentRequirement, Utility.GetTransfusionCategoryCodeFromString("CR"));
			Assert.AreEqual(TransfusionRequirementCategoryCode.AntigenNegative, Utility.GetTransfusionCategoryCodeFromString("AN"));
			Assert.AreEqual(TransfusionRequirementCategoryCode.AntibodyIdentified, Utility.GetTransfusionCategoryCodeFromString("AS"));
			Assert.AreEqual(TransfusionRequirementCategoryCode.Unknown, Utility.GetTransfusionCategoryCodeFromString(string.Empty));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionCategoryCodeFromString_Fail()
		{
		}

		[Test]
		public void GetTransfusionCategoryCodeFromEnum_Pass()
		{
			Assert.AreEqual("CR", Utility.GetTransfusionCategoryCodeFromEnum(TransfusionRequirementCategoryCode.ComponentRequirement));
			Assert.AreEqual("AN", Utility.GetTransfusionCategoryCodeFromEnum(TransfusionRequirementCategoryCode.AntigenNegative));
			Assert.AreEqual("AS", Utility.GetTransfusionCategoryCodeFromEnum(TransfusionRequirementCategoryCode.AntibodyIdentified));
			Assert.AreEqual(string.Empty, Utility.GetTransfusionCategoryCodeFromEnum(TransfusionRequirementCategoryCode.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionCategoryCodeFromEnum_Fail()
		{
		}

		[Test]
		public void GetProductTypeFromProductTypeCode_Pass()
		{
			Assert.AreEqual(Common.ProductType.WholeBlood, Utility.GetProductTypeFromProductTypeCode("E1"));
		}

		[Test]
		[ExpectedException(typeof(FormatException))]
		public void GetProductTypeFromProductTypeCode_Fail()
		{
			Utility.GetProductTypeFromProductTypeCode("KABOOM");
		}

		[Test]
		public void GetTestEntryMethodCodeFromTestEntryMethodEnum_Pass()
		{
			Assert.AreEqual("M", Utility.GetTestEntryMethodCodeFromTestEntryMethodEnum(TestEntryMethod.Manual));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestEntryMethodCodeFromTestEntryMethodEnum_Fail()
		{
		}

		[Test]
		public void GetProductTypeCodeFromProductTypeEnum_Pass()
		{
			Assert.AreEqual("E010", Utility.GetProductTypeCodeFromProductTypeEnum(ProductType.FreshFrozenPlasma));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductTypeCodeFromProductTypeEnum_Fail()
		{
		}

		[Test]
		public void GetSexCodeFromSexEnum_Pass()
		{
			Assert.AreEqual('M', Utility.GetSexCodeFromSexEnum(Sex.Male));
			Assert.AreEqual('F', Utility.GetSexCodeFromSexEnum(Sex.Female));
			Assert.AreEqual('U', Utility.GetSexCodeFromSexEnum(Sex.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSexCodeFromSexEnum_Fail()
		{
		}

		[Test]
		public void GetSexEnumFromSexChar_Pass()
		{
			Assert.AreEqual(Sex.Male, Utility.GetSexEnumFromSexChar('M') );
			Assert.AreEqual(Sex.Female, Utility.GetSexEnumFromSexChar('F') );
			Assert.AreEqual(Sex.Unknown, Utility.GetSexEnumFromSexChar('U') );

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSexEnumFromSexChar_Fail()
		{
		}

		[Test]
		public void GetOrderStatusCodeFromEnum_Pass()
		{
			Assert.AreEqual('A', Utility.GetOrderStatusCodeFromEnum(OrderStatus.Accepted));
			Assert.AreEqual('C', Utility.GetOrderStatusCodeFromEnum(OrderStatus.Complete));
			Assert.AreEqual('H', Utility.GetOrderStatusCodeFromEnum(OrderStatus.Hold));
			Assert.AreEqual('P', Utility.GetOrderStatusCodeFromEnum(OrderStatus.Pending));
			Assert.AreEqual('X', Utility.GetOrderStatusCodeFromEnum(OrderStatus.Cancelled));
			Assert.AreEqual(char.MinValue, Utility.GetOrderStatusCodeFromEnum(OrderStatus.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderStatusCodeFromEnum_Fail()
		{
		}


		[Test]
		public void GetOrderStatusCodeFromString_Pass()
		{
			Assert.AreEqual(OrderStatus.Accepted, Utility.GetOrderStatusCodeFromString("A"));
			Assert.AreEqual(OrderStatus.Complete, Utility.GetOrderStatusCodeFromString("C"));
			Assert.AreEqual(OrderStatus.Hold, Utility.GetOrderStatusCodeFromString("H"));
			Assert.AreEqual(OrderStatus.Pending, Utility.GetOrderStatusCodeFromString("P"));
			Assert.AreEqual(OrderStatus.Cancelled, Utility.GetOrderStatusCodeFromString("X"));
			Assert.AreEqual(OrderStatus.Unknown, Utility.GetOrderStatusCodeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderStatusCodeFromString_Fail()
		{
		}

		[Test]
		public void GetOrderUrgencyCodeFromEnum_Pass()
		{
			Assert.AreEqual('A', Utility.GetOrderUrgencyCodeFromEnum(OrderUrgency.ASAP));
			Assert.AreEqual('P', Utility.GetOrderUrgencyCodeFromEnum(OrderUrgency.PreOp));
			Assert.AreEqual('R', Utility.GetOrderUrgencyCodeFromEnum(OrderUrgency.Routine));
			Assert.AreEqual('S', Utility.GetOrderUrgencyCodeFromEnum(OrderUrgency.STAT));
			Assert.AreEqual(char.MinValue, Utility.GetOrderUrgencyCodeFromEnum(OrderUrgency.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderUrgencyCodeFromEnum_Fail()
		{
		}

		[Test]
		public void GetOrderUrgencyCodeFromString_Pass()
		{
			Assert.AreEqual(OrderUrgency.ASAP, Utility.GetOrderUrgencyCodeFromString("A"));
			Assert.AreEqual(OrderUrgency.PreOp, Utility.GetOrderUrgencyCodeFromString("P"));
			Assert.AreEqual(OrderUrgency.Routine, Utility.GetOrderUrgencyCodeFromString("R"));
			Assert.AreEqual(OrderUrgency.STAT, Utility.GetOrderUrgencyCodeFromString("S"));
			Assert.AreEqual(OrderUrgency.Unknown, Utility.GetOrderUrgencyCodeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderUrgencyCodeFromString_Fail()
		{
		}

		[Test]
		public void GetTaskStatusCodeFromEnum_Pass()
		{
			Assert.AreEqual('C', Utility.GetTaskStatusCodeFromEnum(TaskStatus.Completed));
			Assert.AreEqual('E', Utility.GetTaskStatusCodeFromEnum(TaskStatus.Expired));
			Assert.AreEqual('F', Utility.GetTaskStatusCodeFromEnum(TaskStatus.Filled));
			Assert.AreEqual('I', Utility.GetTaskStatusCodeFromEnum(TaskStatus.InProgress));
			Assert.AreEqual('N', Utility.GetTaskStatusCodeFromEnum(TaskStatus.NotStarted));
			Assert.AreEqual('P', Utility.GetTaskStatusCodeFromEnum(TaskStatus.PartiallyCompleted));
			Assert.AreEqual('R', Utility.GetTaskStatusCodeFromEnum(TaskStatus.ResultsCorrected));
			Assert.AreEqual(char.MinValue, Utility.GetTaskStatusCodeFromEnum(TaskStatus.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTaskStatusCodeFromEnum_Fail()
		{
		}

		[Test]
		public void GetTaskStatusCodeFromString_Pass()
		{
			Assert.AreEqual(TaskStatus.Completed, Utility.GetTaskStatusCodeFromString("C"));
			Assert.AreEqual(TaskStatus.Expired, Utility.GetTaskStatusCodeFromString("E"));
			Assert.AreEqual(TaskStatus.Filled, Utility.GetTaskStatusCodeFromString("F"));
			Assert.AreEqual(TaskStatus.InProgress, Utility.GetTaskStatusCodeFromString("I"));
			Assert.AreEqual(TaskStatus.NotStarted, Utility.GetTaskStatusCodeFromString("N"));
			Assert.AreEqual(TaskStatus.PartiallyCompleted, Utility.GetTaskStatusCodeFromString("P"));
			Assert.AreEqual(TaskStatus.ResultsCorrected, Utility.GetTaskStatusCodeFromString("R"));
			Assert.AreEqual(TaskStatus.Unknown, Utility.GetTaskStatusCodeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTaskStatusCodeFromString_Fail()
		{
		}

		[Test]
		public void GetSpecimenStatusCodeFromString_Pass()
		{
			Assert.AreEqual(SpecimenStatus.InBloodBank, Utility.GetSpecimenStatusCodeFromString("A"));
			Assert.AreEqual(SpecimenStatus.ConvertedFromVista, Utility.GetSpecimenStatusCodeFromString("C"));
			Assert.AreEqual(SpecimenStatus.NSR, Utility.GetSpecimenStatusCodeFromString("N"));
			Assert.AreEqual(SpecimenStatus.Required, Utility.GetSpecimenStatusCodeFromString("R"));
			Assert.AreEqual(SpecimenStatus.Unknown, Utility.GetSpecimenStatusCodeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSpecimenStatusCodeFromString_Fail()
		{
		}

		[Test]
		public void GetPatientChangeStatusCodeFromEnum_Pass()
		{
			Assert.AreEqual('E', Utility.GetPatientChangeStatusCodeFromEnum(PatientChangeStatus.Error));
			Assert.AreEqual('I', Utility.GetPatientChangeStatusCodeFromEnum(PatientChangeStatus.InProcess));
			Assert.AreEqual('P', Utility.GetPatientChangeStatusCodeFromEnum(PatientChangeStatus.PendingProcessing));
			Assert.AreEqual('S', Utility.GetPatientChangeStatusCodeFromEnum(PatientChangeStatus.SuccessfullyProcessed));
			Assert.AreEqual(char.MinValue, Utility.GetPatientChangeStatusCodeFromEnum(PatientChangeStatus.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPatientChangeStatusCodeFromEnum_Fail()
		{
		}

		[Test]
		public void GetPatientChangeStatusCodeFromString_Pass()
		{
			Assert.AreEqual(PatientChangeStatus.Error, Utility.GetPatientChangeStatusCodeFromString("E"));
			Assert.AreEqual(PatientChangeStatus.InProcess, Utility.GetPatientChangeStatusCodeFromString("I"));
			Assert.AreEqual(PatientChangeStatus.PendingProcessing, Utility.GetPatientChangeStatusCodeFromString("P"));
			Assert.AreEqual(PatientChangeStatus.SuccessfullyProcessed, Utility.GetPatientChangeStatusCodeFromString("S"));
			Assert.AreEqual(PatientChangeStatus.Unknown, Utility.GetPatientChangeStatusCodeFromString("@"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPatientChangeStatusCodeFromString_Fail()
		{
		}

		[Test]
		public void GetISBTFromString_Pass()
		{
			Assert.AreEqual(ISBTScan.ABORh, Utility.GetISBTFromString("=%TEST"));
			Assert.AreEqual(ISBTScan.ExpirationDate, Utility.GetISBTFromString("&>TEST"));
			Assert.AreEqual(ISBTScan.ProductCode, Utility.GetISBTFromString("=<TEST"));
			Assert.AreEqual(ISBTScan.UnitId, Utility.GetISBTFromString("=TEST"));
			Assert.AreEqual(ISBTScan.Unknown, Utility.GetISBTFromString("TEST"));
		}

		[Test]
		public void GetISBTFromString_Fail()
		{
			Assert.AreEqual(ISBTScan.Unknown, Utility.GetISBTFromString(string.Empty));
		}

		[Test]
		public void GetReactivityPhaseTextFromCode_Pass()
		{
			Assert.AreEqual(ReactivityPhase.IS.ToString(), Utility.GetReactivityPhaseTextFromCode("1"));
			Assert.AreEqual(ReactivityPhase.IAT.ToString(), Utility.GetReactivityPhaseTextFromCode("2"));
			Assert.AreEqual(ReactivityPhase.ISandIAT.ToString().Replace("and","/"), Utility.GetReactivityPhaseTextFromCode("3"));
			Assert.AreEqual(ReactivityPhase.ISandRT.ToString().Replace("and","/"), Utility.GetReactivityPhaseTextFromCode("4"));
			Assert.AreEqual(ReactivityPhase.ISand37.ToString().Replace("and","/"), Utility.GetReactivityPhaseTextFromCode("5"));
			Assert.AreEqual(ReactivityPhase.AHGandCC.ToString(), Utility.GetReactivityPhaseTextFromCode("6"));
			Assert.AreEqual(ReactivityPhase.CC.ToString(), Utility.GetReactivityPhaseTextFromCode("7"));
			Assert.AreEqual(ReactivityPhase.ThreeSevenandAHG.ToString().Replace("Three","3").Replace("Seven","7").Replace("and","/"), Utility.GetReactivityPhaseTextFromCode("8"));
			Assert.AreEqual(ReactivityPhase.All.ToString(), Utility.GetReactivityPhaseTextFromCode("9"));
			Assert.AreEqual(ReactivityPhase.Unknown.ToString(), Utility.GetReactivityPhaseTextFromCode("31"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReactivityPhaseTextFromCode_Fail()
		{
		}

		[Test]
		public void GetCrossmatchResultStringFromEnum_Pass()
		{
			Assert.AreEqual("E", Utility.GetCrossmatchResultStringFromEnum(CrossmatchResult.CompatibleEXM));
			Assert.AreEqual("G", Utility.GetCrossmatchResultStringFromEnum(CrossmatchResult.IncompatibleDirectorApprovalNeeded));
			Assert.AreEqual("C", Utility.GetCrossmatchResultStringFromEnum(CrossmatchResult.CompatibleSafeToTransfuse));
			Assert.AreEqual("I", Utility.GetCrossmatchResultStringFromEnum(CrossmatchResult.IncompatibleUnsafeToTransfuse));
			Assert.AreEqual("D", Utility.GetCrossmatchResultStringFromEnum(CrossmatchResult.CompatibleDontTransfuse));
			Assert.AreEqual(string.Empty, Utility.GetCrossmatchResultStringFromEnum(CrossmatchResult.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCrossmatchResultStringFromEnum_Fail()
		{
		}

		[Test]
		public void GetCrossmatchResultEnumFromString_Pass()
		{
			Assert.AreEqual(CrossmatchResult.CompatibleEXM, Utility.GetCrossmatchResultEnumFromString("E"));
			Assert.AreEqual(CrossmatchResult.IncompatibleDirectorApprovalNeeded, Utility.GetCrossmatchResultEnumFromString("G"));
			Assert.AreEqual(CrossmatchResult.CompatibleSafeToTransfuse, Utility.GetCrossmatchResultEnumFromString("C"));
			Assert.AreEqual(CrossmatchResult.IncompatibleUnsafeToTransfuse, Utility.GetCrossmatchResultEnumFromString("I"));
			Assert.AreEqual(CrossmatchResult.CompatibleDontTransfuse, Utility.GetCrossmatchResultEnumFromString("D"));
			Assert.AreEqual(CrossmatchResult.Unknown, Utility.GetCrossmatchResultEnumFromString(string.Empty));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCrossmatchResultEnumFromString_Fail()
		{
		}

		[Test]
		public void GetTestResultEnumFromString_Pass()
		{
			Assert.AreEqual(TestResult.A, Utility.GetTestResultEnumFromString("A"));
			Assert.AreEqual(TestResult.AB, Utility.GetTestResultEnumFromString("AB"));
			Assert.AreEqual(TestResult.B, Utility.GetTestResultEnumFromString("B"));
			Assert.AreEqual(TestResult.F, Utility.GetTestResultEnumFromString("F"));
			Assert.AreEqual(TestResult.H, Utility.GetTestResultEnumFromString("H"));
			Assert.AreEqual(TestResult.I, Utility.GetTestResultEnumFromString("I"));
			Assert.AreEqual(TestResult.M, Utility.GetTestResultEnumFromString("M"));
			Assert.AreEqual(TestResult.N, Utility.GetTestResultEnumFromString("N"));
			Assert.AreEqual(TestResult.O, Utility.GetTestResultEnumFromString("O"));
			Assert.AreEqual(TestResult.P, Utility.GetTestResultEnumFromString("P"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestResultEnumFromString_Fail()
		{
		}

		[Test]
		public void GetTestingMethodCodeFromEnum_Pass()
		{
			Assert.AreEqual('G', Utility.GetTestingMethodCodeFromEnum(TestingMethod.Gel));
			Assert.AreEqual('S', Utility.GetTestingMethodCodeFromEnum(TestingMethod.Solid));
			Assert.AreEqual('T', Utility.GetTestingMethodCodeFromEnum(TestingMethod.Tube));
			Assert.AreEqual('U', Utility.GetTestingMethodCodeFromEnum(TestingMethod.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingMethodCodeFromEnum_Fail()
		{
		}

		[Test]
		public void GetTestingMethodEnumFromCode_Pass()
		{
			Assert.AreEqual(TestingMethod.Gel, Utility.GetTestingMethodEnumFromCode('G'));
			Assert.AreEqual(TestingMethod.Solid, Utility.GetTestingMethodEnumFromCode('S'));
			Assert.AreEqual(TestingMethod.Tube, Utility.GetTestingMethodEnumFromCode('T'));
			Assert.AreEqual(TestingMethod.Unknown, Utility.GetTestingMethodEnumFromCode('U'));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingMethodEnumFromCode_Fail()
		{
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
			string[] sColumns = {"A", "B", "C"};
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add("A");
			dtTest.Columns.Add("B");
			dtTest.Columns.Add("C");

			Assert.AreEqual(true, Utility.VerifyMinColumnsInDataTable(sColumns, dtTest));
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{
			string[] sColumns = {"A", "B", "C", "D"};
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add("A");
			dtTest.Columns.Add("B");
			dtTest.Columns.Add("C");

			Assert.AreEqual(false, Utility.VerifyMinColumnsInDataTable(sColumns, dtTest));
		}

		[Test]
		public void GetVbecsSessionCount_Pass()
		{
			int tstValue = Common.Utility.GetVbecsSessionCount(Common.LogonUser.LogonUserName);

            //Code copied down from Common.Utility.GetVbecsSessionCount()
            int visualStudioCount = 0;      //How many vshost.exe processes belong to me. 

            //Generic with VBECS.%.EXE - should catch VBECS and VBECS Admin also  debugs (VBECS.vshost.exe, etc) 
            System.Management.ObjectQuery oQuery = new System.Management.ObjectQuery("Select * from Win32_Process where name LIKE 'VBECS%vshost%.EXE'");
            System.Management.ManagementObjectSearcher oSearcher = new System.Management.ManagementObjectSearcher(oQuery);

            foreach (System.Management.ManagementObject oReturn in oSearcher.Get())
            {
                string[] ownerName = new string[2];
                oReturn.InvokeMethod("GetOwner", (object[])ownerName);

                //If we don't have admin rights on the machine, we won't be able to 
                //actually SEE the owner of processes that don't belong to them - hence, NULL
                if (ownerName[0] == null) continue;

                if (ownerName[0].ToUpper() == Common.LogonUser.LogonUserName.ToUpper())
                {
                    visualStudioCount++;
                }
            }

			Assert.AreEqual(0,tstValue-visualStudioCount);		//in case the unit test executor has visual studio running (not a concern on real app servers)
		}

		[Test]
		public void GetVbecsSessionCount_Fail()
		{
			int tstValue = Common.Utility.GetVbecsSessionCount("B2en4d4er534");
			Assert.AreEqual(0,tstValue);
		}

		[Test]
		public void ParseStringwithSpaces_Pass()
		{
			Assert.AreEqual("a Bc", Utility.ParseStringwithSpaces("aBc"));
		}

		[Test]
        [Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ParseStringwithSpaces_Fail()
		{
		}

		[Test]
		public void ParseStringwithSpacesDeleteSet_Pass()
		{
			Assert.AreEqual("A Bc ", Utility.ParseStringwithSpaces("set_ABc", true) );
			Assert.AreEqual("set_A Bc ", Utility.ParseStringwithSpaces("set_ABc", false) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ParseStringwithSpacesDeleteSet_Fail()
		{
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void MessageBeep_Pass()
		{
			//How would one test a beep, hmm?
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void MessageBeep_Fail()
		{
		}

		[Test]
		public void SumBrokenRulesMessages_Pass()
		{
			string tmpValue = "first" + Environment.NewLine + "second" + Environment.NewLine + "third";

			Assert.AreEqual(tmpValue, Utility.SumBrokenRulesMessages( "first", "second", "third", string.Empty ) );
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentNullException))]
		public void SumBrokenRulesMessages_Fail()
		{
			Assert.IsNull(Utility.SumBrokenRulesMessages( null ) );
		}

		[Test]
		public void AppendLastUpdateInformation_Pass()
		{
			DataTable dtBefore = new DataTable();
			dtBefore.Columns.Add("A");
			dtBefore.Rows.Add(dtBefore.NewRow());

			DataTable dtAfter = Utility.AppendLastUpdateInformation(dtBefore, UpdateFunction.UnitTests);

			Assert.AreEqual(2, dtAfter.Columns.Count, "Columns.Count");
			Assert.AreEqual((int)UpdateFunction.UnitTests, (int)dtAfter.Rows[0][VbecsTables.BloodUnit.LastUpdateFunctionId]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AppendLastUpdateInformation_Fail()
		{
		}

		[Test]
		public void GetOrderAlertTypeTypeFromString_Pass()
		{
			Assert.AreEqual(OrderAlertTypeCode.All_orders, Utility.GetOrderAlertTypeTypeFromString("A"));
			Assert.AreEqual(OrderAlertTypeCode.Hour_limit, Utility.GetOrderAlertTypeTypeFromString("H"));
			Assert.AreEqual(OrderAlertTypeCode.Specimen_OK_or_NA, Utility.GetOrderAlertTypeTypeFromString("S"));
			Assert.AreEqual(OrderAlertTypeCode.Unknown, Utility.GetOrderAlertTypeTypeFromString("U"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderAlertTypeTypeFromString_Fail()
		{
		}

		[Test]
		public void GetOrderAlertTypeTypeFromEnum_Pass()
		{
			Assert.AreEqual("A", Utility.GetOrderAlertTypeTypeFromEnum(OrderAlertTypeCode.All_orders));
			Assert.AreEqual("H", Utility.GetOrderAlertTypeTypeFromEnum(OrderAlertTypeCode.Hour_limit));
			Assert.AreEqual("S", Utility.GetOrderAlertTypeTypeFromEnum(OrderAlertTypeCode.Specimen_OK_or_NA));

			Assert.IsNull(Utility.GetOrderAlertTypeTypeFromEnum(OrderAlertTypeCode.Unknown), "Null");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderAlertTypeTypeFromEnum_Fail()
		{
		}

		[Test]
		public void GetCautionTagCrossmatchText_Pass()
		{
			Assert.AreEqual(Common.StrRes.OtherMsg.UC043.Compatible().ResString, Utility.GetCautionTagCrossmatchText(CrossmatchResult.CompatibleSafeToTransfuse));
			Assert.AreEqual(Common.StrRes.OtherMsg.UC043.Compatible().ResString, Utility.GetCautionTagCrossmatchText(CrossmatchResult.CompatibleEXM));
			Assert.AreEqual(Common.StrRes.OtherMsg.UC043.MedicalDirectorApprovalOnly().ResString, Utility.GetCautionTagCrossmatchText(CrossmatchResult.IncompatibleDirectorApprovalNeeded));
			Assert.AreEqual(Common.StrRes.OtherMsg.UC043.NoCrossmatchAtIssue().ResString, Utility.GetCautionTagCrossmatchText(CrossmatchResult.IncompatibleUnsafeToTransfuse));
			Assert.AreEqual(Common.StrRes.OtherMsg.UC043.NoCrossmatchAtIssue().ResString, Utility.GetCautionTagCrossmatchText(CrossmatchResult.Unknown));
			Assert.AreEqual(Common.StrRes.OtherMsg.UC043.NoCrossmatchAtIssue().ResString, Utility.GetCautionTagCrossmatchText(CrossmatchResult.CompatibleDontTransfuse));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCautionTagCrossmatchText_Fail()
		{
		}

		[Test]
		public void GetAboFromString_Pass()
		{
			Assert.AreEqual(ABO.A, Utility.GetAboFromString("A"));
			Assert.AreEqual(ABO.B, Utility.GetAboFromString("B"));
			Assert.AreEqual(ABO.AB, Utility.GetAboFromString("AB"));
			Assert.AreEqual(ABO.O, Utility.GetAboFromString("O"));
			Assert.AreEqual(ABO.I, Utility.GetAboFromString("I"));
			Assert.AreEqual(ABO.Mx, Utility.GetAboFromString("MX"));
			Assert.AreEqual(ABO.NA, Utility.GetAboFromString("U"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAboFromString_Fail()
		{
		}

		
		[Test]
		public void GetAboFromEnum_Pass()
		{
			string tstValue = string.Empty;

			tstValue = Utility.GetAboFromEnum(Common.ABO.A);
			Assert.AreEqual("A", tstValue, "Common.ABO.A");

			tstValue = Utility.GetAboFromEnum(Common.ABO.B);
			Assert.AreEqual("B", tstValue, "Common.ABO.B");

			tstValue = Utility.GetAboFromEnum(Common.ABO.AB);
			Assert.AreEqual("AB", tstValue, "Common.ABO.AB");

			tstValue = Utility.GetAboFromEnum(Common.ABO.O);
			Assert.AreEqual("O", tstValue, "Common.ABO.O");

			tstValue = Utility.GetAboFromEnum(Common.ABO.Mx);
			Assert.AreEqual("Mx", tstValue, "Common.ABO.Mx");

			tstValue = Utility.GetAboFromEnum(Common.ABO.NA);
			Assert.AreEqual("NA", tstValue, "Common.ABO.NA");

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAboFromEnum_Fail()
		{
		}


		[Test]
		public void GetRhFromString_Pass()
		{
			Assert.AreEqual(RH.Positive, Utility.GetRhFromString("P"));
			Assert.AreEqual(RH.Negative, Utility.GetRhFromString("N"));
			Assert.AreEqual(RH.Inconclusive, Utility.GetRhFromString("I"));
			Assert.AreEqual(RH.NotProvided, Utility.GetRhFromString("U"));
			Assert.AreEqual(RH.Blank, Utility.GetRhFromString("Z"));
			Assert.AreEqual(RH.PooledRH, Utility.GetRhFromString("Y"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRhFromString_Fail()
		{
		}

		[Test]
		public void GetRhFromEnum_Pass()
		{
			string tstValue = string.Empty;

			tstValue = Utility.GetRhFromEnum(Common.RH.Blank);
			Assert.AreEqual(string.Empty, tstValue, "Blank");

			tstValue = Utility.GetRhFromEnum(Common.RH.Inconclusive);
			Assert.AreEqual("I", tstValue, "Inconclusive");

			tstValue = Utility.GetRhFromEnum(Common.RH.Negative);
			Assert.AreEqual("N", tstValue, "Negative");

			tstValue = Utility.GetRhFromEnum(Common.RH.NotProvided);
			Assert.AreEqual("NA", tstValue, "NotProvided");

			tstValue = Utility.GetRhFromEnum(Common.RH.PooledRH);
			Assert.AreEqual("Y", tstValue, "PooledRH");
			
			tstValue = Utility.GetRhFromEnum(Common.RH.Positive);
			Assert.AreEqual("P", tstValue, "Positive");
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRhFromEnum_Fail()
		{
		}

		//*****************************************************
		// private method to create a blank table to Tests
		//*****************************************************
		private static DataTable GetTestDataTable()
		{
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add( "C1" );
			dtTest.Columns.Add( "C2" );

			return dtTest;
		}

		[Test]
		public void RequireColumns_Pass_1()
		{
			Utility.RequireColumns( GetTestDataTable().NewRow(), "C1", "C2" );
			//If it doesn't throw an exception, it worked.
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void RequireColumns_Fail_3()
		{
			Utility.RequireColumns( GetTestDataTable().NewRow(), "C10" );
		}

		[Test]
		public void RequireColumns_Pass_2()
		{
			Utility.RequireColumns( GetTestDataTable().NewRow() );
			//If it doesn't throw an exception, it worked.
			Assert.IsTrue(true);
		}	

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void RequireColumns_Fail_1()
		{
			Utility.RequireColumns( null, "C" );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void RequireColumns_Fail_2()
		{
			Utility.RequireColumns( GetTestDataTable().NewRow(), "C1", null, "C2" );
		}

		[Test]
		public void RequireNonNullColumns_DataRow_Pass()
		{
			DataRow _dr = GetTestDataTable().NewRow();
			_dr[0] = "test";
			_dr[1] = "test 2";

			Utility.RequireNonNullColumns( _dr, "C1", "C2" );
			//If it doesn't throw an exception, it worked.
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void RequireNonNullColumns_DataRow_Fail()
		{
			Utility.RequireNonNullColumns( GetTestDataTable().NewRow(), "C1", "C2" );
		}

		[Test]
		public void RequireNonNullColumns_DataTable_Pass()
		{
			DataTable _dt = GetTestDataTable();
			_dt.Rows.Add(_dt.NewRow());

			_dt.Rows[0][0] = "test";
			_dt.Rows[0][1] = "test 2";

			Utility.RequireNonNullColumns( _dt, "C1", "C2" );
			//If it doesn't throw an exception, it worked.
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void RequireNonNullColumns_DataTable_Fail()
		{
			DataTable dtTest = GetTestDataTable();
			dtTest.Rows.Add(dtTest.NewRow());

			Utility.RequireNonNullColumns( dtTest, "C1", "C2" );
		}

		[Test]
		public void GetPatientChangeStatusFromCode_Pass()
		{
			Assert.AreEqual('E', Utility.GetPatientChangeStatusFromCode(PatientChangeStatus.Error));
			Assert.AreEqual('I', Utility.GetPatientChangeStatusFromCode(PatientChangeStatus.InProcess));
			Assert.AreEqual('P', Utility.GetPatientChangeStatusFromCode(PatientChangeStatus.PendingProcessing));
			Assert.AreEqual('S', Utility.GetPatientChangeStatusFromCode(PatientChangeStatus.SuccessfullyProcessed));
			Assert.AreEqual(char.MinValue, Utility.GetPatientChangeStatusFromCode(PatientChangeStatus.Unknown));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPatientChangeStatusFromCode_Fail()
		{
		}
		
		private bool ForcedCheckLogicAndTestMethod( bool returnValue, ref int counterToIncrease )
		{
			counterToIncrease++;

			return returnValue;
		}

		[Test]public void ForcedCheckLogicAnd_Pass_1()
		{
			int _counterToIncrease = 0;

			Assert.AreEqual(false, Common.Utility.ForcedCheckLogicAnd( ForcedCheckLogicAndTestMethod( false, ref _counterToIncrease ), ForcedCheckLogicAndTestMethod( true, ref _counterToIncrease ) ), "ReturnValue" );

			Assert.AreEqual(2, _counterToIncrease, "Value" );
		}

		[Test]public void ForcedCheckLogicAnd_Pass_2()
		{
			Assert.IsTrue( Common.Utility.ForcedCheckLogicAnd() );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ForcedCheckLogicAnd_Fail(){}

		[Test]
		public void DescSortOrderSuffix_Pass()
		{
			Assert.IsNotNull( Common.Utility.DescSortOrderSuffix );
		}

		[Test]
		 [Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void DescSortOrderSuffix_Fail() {}

		[Test]
		public void GetIsActiveStatusByStatusCode_Pass_1()
		{
			Assert.IsTrue( Utility.GetIsActiveStatusByStatusCode( (object)'A' ) );
		}

		[Test]
		public void GetIsActiveStatusByStatusCode_Pass_2()
		{
			Assert.IsTrue( !Utility.GetIsActiveStatusByStatusCode( (object)'X' ) );
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetIsActiveStatusByStatusCode_Fail_1()
		{
			Utility.GetIsActiveStatusByStatusCode( null );
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentOutOfRangeException))]
		public void GetIsActiveStatusByStatusCode_Fail_2()
		{
			Utility.GetIsActiveStatusByStatusCode( DBNull.Value );
		}

		[Test]
		public void GetRecordStatusCodeCharFromBoolean_Pass()
		{
			char tstValue = char.MinValue;

			tstValue = Utility.GetRecordStatusCodeCharFromBoolean(true);
			Assert.AreEqual('A', tstValue, "true-value");

			tstValue = Utility.GetRecordStatusCodeCharFromBoolean(false);
			Assert.AreEqual('X', tstValue, "false-value");

		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecordStatusCodeCharFromBoolean_Fail()
		{
		}

		[Test]
		public void GetAdditionalBloodUnitSearchCriteriaValueFromEnum_Pass()
		{
			int tstValue = int.MinValue;

			tstValue = Utility.GetAdditionalBloodUnitSearchCriteriaValueFromEnum(Common.AdditionalBloodUnitSearchCriteria.InactiveUnits);
			Assert.AreEqual(2, tstValue, "InactiveUnits");

			tstValue = Utility.GetAdditionalBloodUnitSearchCriteriaValueFromEnum(Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus);
			Assert.AreEqual(1, tstValue, "UnitsInFinalStatus");

			tstValue = Utility.GetAdditionalBloodUnitSearchCriteriaValueFromEnum(Common.AdditionalBloodUnitSearchCriteria.None);
			Assert.AreEqual(0, tstValue, "None");
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAdditionalBloodUnitSearchCriteriaValueFromEnum_Fail()
		{
		}

		[Test]
		public void InterpretAbo_Pass()
		{
			string tstValue = string.Empty;
			

			//O tests --------
			tstValue = Utility.InterpretAbo("0", "0", "X", "1", "1");
			Assert.AreEqual("O", tstValue, "O-X");
			
			tstValue = Utility.InterpretAbo("0", "0", "N", "1", "1");
			Assert.AreEqual("O", tstValue, "O-N");
			

			//A tests -------
			tstValue = Utility.InterpretAbo("1", "0", "X", "0", "1");
			Assert.AreEqual("A", tstValue, "A-X");
			
			tstValue = Utility.InterpretAbo("1", "0", "1", "0", "1");
			Assert.AreEqual("A", tstValue, "A-P");

			//B tests -------
			tstValue = Utility.InterpretAbo("0", "1", "X", "1", "0");
			Assert.AreEqual("B", tstValue, "B-X");
			
			tstValue = Utility.InterpretAbo("0", "1", "1", "1", "0");
			Assert.AreEqual("B", tstValue, "B-P");
			
			//AB tests -------
			tstValue = Utility.InterpretAbo("1", "1", "X", "0", "0");
			Assert.AreEqual("AB", tstValue, "AB-X");
			
			tstValue = Utility.InterpretAbo("1", "1", "1", "0", "0");
			Assert.AreEqual("AB", tstValue, "AB-P");
		}
		
		[Test]
		public void InterpretAbo_Fail()
		{
			string tstValue = string.Empty;
			
			tstValue = Utility.InterpretAbo("X", "1", "X", "X", "1");
			Assert.AreEqual("I", tstValue);
		}

		[Test]
		public void InterpretRh_Pass()
		{

			string tstValue = string.Empty;

			//P tests-----------
			tstValue = Utility.InterpretRh("1", "X");
			Assert.AreEqual("P", tstValue, "P-X");

			tstValue = Utility.InterpretRh("1", "0");
			Assert.AreEqual("P", tstValue, "P-N");

			//N tests----------
			tstValue = Utility.InterpretRh("0", "X");
			Assert.AreEqual("N", tstValue, "N-X");

			tstValue = Utility.InterpretRh("0", "0");
			Assert.AreEqual("N", tstValue, "N-N");
		}
		
		[Test]
		public void InterpretRh_Fail()
		{
			string tstValue = Utility.InterpretRh("1", "1");
			Assert.AreEqual("I", tstValue);
		}
		
		[Test]
		public void GetExceptionReportTypeFromString_Pass()
		{
			Common.ExceptionReportType tstValue = Common.ExceptionReportType.Unknown;

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportAboIncompatibleTransfusion");
			Assert.AreEqual(ExceptionReportType.ExceptionReportAboIncompatibleTransfusion, tstValue, "ExceptionReportAboIncompatibleTransfusion");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportAntigenTest");
			Assert.AreEqual(ExceptionReportType.ExceptionReportAntigenTest, tstValue, "ExceptionReportAntigenTest");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportCautionTagBTRFPrinting");
			Assert.AreEqual(ExceptionReportType.ExceptionReportCautionTagBTRFPrinting, tstValue, "ExceptionReportCautionTagBTRFPrinting");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportExpiredTaskProcessed");
			Assert.AreEqual(ExceptionReportType.ExceptionReportExpiredTaskProcessed, tstValue, "ExceptionReportExpiredTaskProcessed");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportExpiredUnit");
			Assert.AreEqual(ExceptionReportType.ExceptionReportExpiredUnitReceived, tstValue, "ExceptionReportExpiredUnitReceived");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportLabelMismatch");
			Assert.AreEqual(ExceptionReportType.ExceptionReportLabelMismatch, tstValue, "ExceptionReportLabelMismatch");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportMain");
			Assert.AreEqual(ExceptionReportType.ExceptionReportMain, tstValue, "ExceptionReportMain");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportPatientAboRH");
			Assert.AreEqual(ExceptionReportType.ExceptionReportPatientAboRh, tstValue, "ExceptionReportPatientAboRH");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportPatientAboRHDiscrepancy");
			Assert.AreEqual(ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy, tstValue, "ExceptionReportPatientAboRHDiscrepancy");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportPatientAntigenDiscrepancy");
			Assert.AreEqual(ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy, tstValue, "ExceptionReportPatientAntigenDiscrepancy");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportPatientRestriction");
			Assert.AreEqual(ExceptionReportType.ExceptionReportPatientRestriction, tstValue, "ExceptionReportPatientRestriction");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportPatientTest");
			Assert.AreEqual(ExceptionReportType.ExceptionReportPatientTest, tstValue, "ExceptionReportPatientTest");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportPatientTestInactivated");
			Assert.AreEqual(ExceptionReportType.ExceptionReportPatientTestInactivated, tstValue, "ExceptionReportPatientTestInactivated");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportQC");
			Assert.AreEqual(ExceptionReportType.ExceptionReportQC, tstValue, "ExceptionReportQC");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportQCInactivated");
			Assert.AreEqual(ExceptionReportType.ExceptionReportQCInactivated, tstValue, "ExceptionReportQCInactivated");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportQCNotPerformed");
			Assert.AreEqual(ExceptionReportType.ExceptionReportQCNotPerformed, tstValue, "ExceptionReportQCNotPerformed");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportQuarantine");
			Assert.AreEqual(ExceptionReportType.ExceptionReportQuarantine, tstValue, "ExceptionReportQuarantine");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportReflexTest");
			Assert.AreEqual(ExceptionReportType.ExceptionReportReflexTest, tstValue, "ExceptionReportReflexTest");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportReturnIssuedUnit");
			Assert.AreEqual(ExceptionReportType.ExceptionReportReturnIssuedUnit, tstValue, "ExceptionReportReturnIssuedUnit");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportSpecimen");
			Assert.AreEqual(ExceptionReportType.ExceptionReportSpecimen, tstValue, "ExceptionReportSpecimen");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportTransfusion");
			Assert.AreEqual(ExceptionReportType.ExceptionReportTransfusion, tstValue, "ExceptionReportTransfusion");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportTransfusionReactionWorkup");
			Assert.AreEqual(ExceptionReportType.ExceptionReportTransfusionReactionWorkup, tstValue, "ExceptionReportTransfusionReactionWorkup");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportTrwSpecimen");
			Assert.AreEqual(ExceptionReportType.ExceptionReportTrwSpecimen, tstValue, "ExceptionReportTrwSpecimen");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitAboRH");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitAboRh, tstValue, "ExceptionReportUnitAboRH");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitERIssuedTestingProblem");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem, tstValue, "ExceptionReportUnitERIssuedTestingProblem");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitIssue");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitIssue, tstValue, "ExceptionReportUnitIssue");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitModification");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitModification, tstValue, "ExceptionReportUnitModification");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitSelection");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitSelection, tstValue, "ExceptionReportUnitSelection");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitSupply");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitSupply, tstValue, "ExceptionReportUnitSupply");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportUnitTest");
			Assert.AreEqual(ExceptionReportType.ExceptionReportUnitTest, tstValue, "ExceptionReportUnitTest");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportEmergencyIssueOrder");
			Assert.AreEqual(ExceptionReportType.ExceptionReportEmergencyIssueOrder, tstValue, "ExceptionReportEmergencyIssueOrder");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportExpiredOrder");
			Assert.AreEqual(ExceptionReportType.ExceptionReportExpiredTaskProcessed, tstValue, "ExceptionReportExpiredOrder");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportRemoveFinalUnitStatus");
			Assert.AreEqual(ExceptionReportType.ExceptionReportRemoveFinalUnitStatus, tstValue, "ExceptionReportRemoveFinalUnitStatus");

			tstValue = Utility.GetExceptionReportTypeFromString("ExceptionReportCrossmatch");
			Assert.AreEqual(ExceptionReportType.ExceptionReportCrossmatch, tstValue, "ExceptionReportCrossmatch");

			tstValue = Utility.GetExceptionReportTypeFromString("Goonies");
			Assert.AreEqual(ExceptionReportType.Unknown, tstValue, "Unknown");
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetExceptionReportTypeFromString_Fail()
		{
		}

		[Test]
		public void IsRestricted_Pass()
		{
			// Test A: donationTypeID = 1
			int donationTypeID = 1;
			Assert.AreEqual(false, Utility.IsRestricted(donationTypeID), "1");
			//
			// Test B: donationTypeID = 2
			donationTypeID = 2;
			Assert.AreEqual(false, Utility.IsRestricted(donationTypeID), "2");
			//
			// Test C donationTypeID = 17
			donationTypeID = 17;
			Assert.AreEqual(false, Utility.IsRestricted(donationTypeID), "17");

		}
		
		[Test]
		public void IsRestricted_Fail()
		{
			int donationTypeID = 3;
			Assert.AreEqual(true, Utility.IsRestricted(donationTypeID), "3");
		}

		[Test]
		public void IsDirected_Pass()
		{
			bool retValue = false;

			retValue = Utility.IsDirected(3);
			Assert.AreEqual(true, retValue, "3");

			retValue = Utility.IsDirected(4);
			Assert.AreEqual(true, retValue, "4");

			retValue = Utility.IsDirected(5);
			Assert.AreEqual(true, retValue, "5");

			retValue = Utility.IsDirected(6);
			Assert.AreEqual(true, retValue, "6");

			retValue = Utility.IsDirected(7);
			Assert.AreEqual(true, retValue, "7");

			retValue = Utility.IsDirected(8);
			Assert.AreEqual(true, retValue, "8");

			retValue = Utility.IsDirected(12);
			Assert.AreEqual(true, retValue, "12");

			retValue = Utility.IsDirected(13);
			Assert.AreEqual(true, retValue, "13");

			retValue = Utility.IsDirected(14);
			Assert.AreEqual(true, retValue, "14");

			retValue = Utility.IsDirected(15);
			Assert.AreEqual(true, retValue, "15");

			retValue = Utility.IsDirected(16);
			Assert.AreEqual(true, retValue, "16");

			retValue = Utility.IsDirected(18);
			Assert.AreEqual(true, retValue, "18");

			retValue = Utility.IsDirected(19);
			Assert.AreEqual(true, retValue, "19");

			retValue = Utility.IsDirected(20);
			Assert.AreEqual(true, retValue, "20");
		}
		
		[Test]
		public void IsDirected_Fail()
		{
			bool retValue = Utility.IsDirected(21);
			Assert.AreEqual(false, retValue, "21");
		}
		
		[Test]
		public void IsAutologous_Pass()
		{
			bool retValue = false;

			retValue = Utility.IsAutologous(9);
			Assert.AreEqual(true, retValue, "9");

			retValue = Utility.IsAutologous(10);
			Assert.AreEqual(true, retValue, "10");

			retValue = Utility.IsAutologous(11);
			Assert.AreEqual(true, retValue, "11");
		}
		
		[Test]
		public void IsAutologous_Fail()
		{	
			bool retValue = Utility.IsAutologous(8);
			Assert.AreEqual(false, retValue, "8");

		}
		
		[Test]
		public void IsDbConnectivityError_Pass()
		{
			string connString = VbecsConfig.Current.PrimaryDbConnectionString;

            if (connString.Contains("Data Source=10."))
                connString = connString.Replace("Data Source=10.", "Data Source=11.");
            else
                connString = connString.Replace("Data Source=", "Data Source=G");

			SqlConnection conn = new SqlConnection( connString );
			SqlCommand cmd = conn.CreateCommand();
			cmd.CommandText = "SELECT * FROM BloodUnit";
			try
			{
				conn.Open();
				cmd.ExecuteNonQuery();
				conn.Close();
				Assert.IsTrue(false, "Connection crapout failed");
			}
			catch(SqlException err)
			{
				bool retValue = Utility.IsDbConnectivityError(err);

				Assert.AreEqual(true, retValue);
			}
		}
		
		[Test]
		public void IsDbConnectivityError_Fail()
		{
			bool retValue = Utility.IsDbConnectivityError(null);

			Assert.AreEqual(false, retValue);
		}
		
		[Test]
		public void FormErrorMessageBasedOnDbConnectivityErrorObject_Pass()
		{
			System.Guid bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct");

			try
			{
				UnitTestUtil.RunSQL("INSERT INTO BloodProduct (BloodProductGuid) VALUES('" + bpGuid.ToString() + "')");
				Assert.IsTrue(false, "SqlException not raised as expected");
			}
			catch(SqlException err)
			{
				string msg = err.Message;

				StrRes.StringResourceItem tstValue = Common.Utility.FormErrorMessageBasedOnDbConnectivityErrorObject(err);

				Assert.AreEqual(StrRes.SysErrMsg.Database.DbConnectivityFailureDescribed(msg), tstValue);
			}

		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FormErrorMessageBasedOnDbConnectivityErrorObject_Fail()
		{
		}

		[Test]
		public void GetPrintersInstalledOnServer_Pass()
		{
			// Assumes that there is at least one printer installed on the server.
			Assert.IsTrue(Common.Utility.GetPrintersInstalledOnServer().GetLength(0)>0);
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPrintersInstalledOnServer_Fail()
		{
		}

		/// <summary>
		/// GetHL7BPDispenseStatusStringFromEnum - PASS
		/// </summary>
		[Test]
		public void GetHL7BPDispenseStatusStringFromEnum_Pass()
		{
			string dispenseStatusString = Common.Utility.GetHL7BPDispenseStatusStringFromEnum( HL7BPDispenseStatus.DS );
			//
			Assert.IsTrue( dispenseStatusString == "DS" );
			//
			dispenseStatusString = Common.Utility.GetHL7BPDispenseStatusStringFromEnum( HL7BPDispenseStatus.RE );
			//
			Assert.IsTrue( dispenseStatusString == "RE" );
			//
			dispenseStatusString = Common.Utility.GetHL7BPDispenseStatusStringFromEnum( HL7BPDispenseStatus.RS );
			//
			Assert.IsTrue( dispenseStatusString == "RS" );
			//
			dispenseStatusString = Common.Utility.GetHL7BPDispenseStatusStringFromEnum( HL7BPDispenseStatus.UK );
			//
			Assert.IsTrue( dispenseStatusString == "UK" );
		}
		
		/// <summary>
		/// GetHL7BPDispenseStatusStringFromEnum - FAIL
		/// </summary>
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetHL7BPDispenseStatusStringFromEnum_Fail()
		{
			
		}

		/// <summary>
		/// GetApplicationOfRecordTypeIntegerValue - PASS
		/// </summary>
		[Test]
		public void GetApplicationOfRecordTypeIntegerValue_Pass()
		{
			int applicationOfRecordType = Common.Utility.GetApplicationOfRecordTypeIntegerValue( ApplicationOfRecordType.VBECS );
			//
			Assert.IsTrue( applicationOfRecordType == 1 );
			//
			applicationOfRecordType = Common.Utility.GetApplicationOfRecordTypeIntegerValue( ApplicationOfRecordType.BCE_COTS );
			//
			Assert.IsTrue( applicationOfRecordType == 2 );
			//
			applicationOfRecordType = Common.Utility.GetApplicationOfRecordTypeIntegerValue( ApplicationOfRecordType.NotSet );
			//
			Assert.IsTrue( applicationOfRecordType == 0 );
		}
		
		/// <summary>
		/// GetApplicationOfRecordTypeIntegerValue - FAIL
		/// </summary>
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetApplicationOfRecordTypeIntegerValue_Fail()
		{
			
		}

	}
}
#endif
